#include <stdio.h>
#define DIM 10

struct persona
{
    char nome[DIM];
    struct persona *mamma;
    struct persona *babbo;
};

typedef struct persona Persona;

void Stampa(Persona *familiare);

int main(void)
{
	printf("Ciao! Vuoi scrivere il tuo albero genealogico?\n");
	
    Persona figlio;
	printf("Inserisci il tuo nome (mi raccomando, %d caratteri precisi contando gli spazi;)):\n", DIM);
    for(int i = 0; i < DIM; i++)
    {
        scanf("%c", &figlio.nome[i]);
    }
    
    Persona mamma;
	printf("Inserisci il nome di tua mamma (mi raccomando, %d caratteri precisi contando gli spazi;)):\n", DIM);
    for(int i = 0; i < DIM; i++)
    {
        scanf("%c", &mamma.nome[i]);
    }

    Persona babbo;
	printf("Inserisci il tuo babbo (mi raccomando, %d caratteri precisi contando gli spazi;)):\n", DIM);
    for(int i = 0; i < DIM; i++)
    {
        scanf("%c", &babbo.nome[i]);
    }

    figlio.mamma = &mamma;
    figlio.babbo = &babbo;

    mamma.mamma = NULL;
    mamma.babbo = NULL;

    babbo.mamma = NULL;
    babbo.babbo = NULL;

	Stampa(&figlio);
    
	return 0;
}

void Stampa(Persona *familiare)
{
    if(familiare == NULL)
    {
		return;
    }
    else
    {	
        for(int i = 0; i < DIM; i++)
        {
            printf("%c", familiare -> nome[i]);
        }
        printf(".\n");
    }
	
	Persona *puntatoreUno = familiare -> mamma;
	if(puntatoreUno == NULL)
    {
        printf("Sconosciuto ");
    }
    else
    {	
        for(int i = 0; i < DIM; i++)
        {
            printf("%c", puntatoreUno -> nome[i]);
        }
    }
	
	Persona *puntatoreDue = familiare -> babbo;
	
	if(puntatoreDue == NULL)
    {
        printf("Sconosciuto ");
    }
    else
    {	
        for(int i = 0; i < DIM; i++)
        {
            printf("%c", puntatoreDue -> nome[i]);
        }
    }
	printf("\n");
	
	Stampa(familiare -> mamma);
	Stampa(familiare -> babbo);
}